﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Security;
using System.Security.Policy;
using System.Security.Permissions;

namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent(); 
        }
 
 
        private void button1_Click(object sender, EventArgs e)
        {
            SecurityTest.ReadFile_AsFullTrust();            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            SecurityTest.ReadFile_AsLocalIntranet();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            SecurityTest.WriteFile_AsFullTrust();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            SecurityTest.WriteFile_AsLocalIntranet();
        }


    }
}



namespace Lessons
{


    

    public static class SecurityTest
    {
        static private readonly string fileName = @"C:\SecurityTestFile.txt";


        /* reads a dummy file and displays its content.
           It is called by other methods forcing a security stack walk.
           It does not demand any specific permission from its caller.
           It succeeds when it is called by the ReadFile_AsFullTrust() because local code is fully trusted.
           It fails when it is called by the ReadFile_AsLocalIntranet() because ReadFile_AsLocalIntranet() 
           is marked to have local intranet permissions */
        static private void ReadFile(string Caller)
        {
            try
            {
                using (StreamReader SR = new StreamReader(fileName))
                {
                    MessageBox.Show(Caller + " - Succes : " + SR.ReadLine());
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(Caller + " - FAILED : " + ex.Message);
            }
        }

        /* It writes to the same dummy file.
           It is called by other methods forcing a security stack walk.
           It demands its callers to have FileIOPermissionAccess.Write to that file. 
           It succeeds when it is called by the WriteFile_AsFullTrust() because local code is fully trusted.
           It fails when it is called by the WriteFile_AsLocalIntranet() because WriteFile_AsLocalIntranet() 
           is marked to have local intranet permissions */
        static private void WriteFile(string Caller)
        {
            try
            {
                /* imperative security syntax
                   this methods checks the permission it demands from its caller to have and throws an exception if the check fails 
                   imperative syntax can perform demands and overrides only, NO requests */
                FileIOPermission FP = new FileIOPermission(FileIOPermissionAccess.Write, fileName); 
                FP.Demand();                 

                using (StreamWriter SW = new StreamWriter(fileName))
                {
                    SW.WriteLine(".Net security test");
                }

                MessageBox.Show(Caller + " - Succes " );
            }
            catch (Exception ex)
            {
                MessageBox.Show(Caller + " - FAILED : " + ex.Message);
            }
        }

        /* a static constructor. Creates a dummy file for test purposes */
        static SecurityTest()
        { 
            using (StreamWriter SW = new StreamWriter(fileName))
            {
                SW.WriteLine(".Net security test");
            }
        }

        public static void ReadFile_AsFullTrust()
        {
            ReadFile("File read Full Trust local caller");
        }


        /* declarative security syntax */
        [PermissionSetAttribute(SecurityAction.PermitOnly, Name = "LocalIntranet")] // makes this code to look like a code coming from a shared network drive
        public static void ReadFile_AsLocalIntranet()
        {
            ReadFile("File read LocalIntranet caller");
        }

        
        public static void WriteFile_AsFullTrust()
        {
            WriteFile("File write Full Trust local caller");
        }

        /* declarative security syntax */
        [PermissionSetAttribute(SecurityAction.PermitOnly, Name = "LocalIntranet")]
        public static void WriteFile_AsLocalIntranet()
        {
            WriteFile("File write LocalIntranet caller");
        }
    }




 
}